--  Tasks:
-- restore_health -       
-- time_tick -   .    ,     
-- sleeping -     , 0 -   
--  Params: -   ,    
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
-- class cow
GameObject = {
--  
    Params = {
        ID="cow";  -- do not change this parameter
        width=1;   -- do not change this parameter
        height=3;  -- do not change this parameter
        health=5000;  -- 
        hungry=4500;  -- 
        thirst=4000;  -- 
        create_product = 20;  --   ()
        product_name = "milk"; -- do not change this parameter
        speed=550;    -- ,    
        group=2;      -- 
        RandomTasks=3;--    
        emotion=4;    -- do not change this parameter
        first_delay_desire = { 5, 6 };  --    ,  .
        Impatience = 50; -- ammount of health that dissapers each second
        GridData= { 1, 1, 1 };   -- do not change this parameter
        start_with_hearts = 3;   --    - 
    };
    -- list of all tasks for an object
    Tasks = {
        eating = { FuncName="EatingTaskExecute",     sleeping={0}, time_tick=1000,  skill_up = 0, restore_health=1000 };
        milking = { FuncName="MilkingTaskExecute",   sleeping={8}, time_tick=1200,  skill_up = 0, restore_health=0, final_cycle=1, not_need_action=1 };
        watering = { FuncName="WateringTaskExecute", sleeping={0}, time_tick=1000,  skill_up = 0,  restore_health=1000 };
        tools = { FuncName="CleaningTaskExecute", sleeping={0}, timer=1, time_tick=100,  skill_up = 0,  restore_health=1000 };
    };
--       
    ActivePoints = { 
        watering = { 
                   { {}, 1,1,0,  0,  1,0,0 };
                   }; 
        eating = { 
                   { {}, 1,1,0,  0,  1,0,0 };
                   }; 
        tools = { 
                   { {}, -1,-1,0,   0,  0,-1,0  };
                   };
        milking = { 
                   { {}, -1,-1,0,   0,  -1,-1,0  };
                   };
        take   = { 
                   { {"milk"}, 2,0,0, 0,  0,0,0 };
                 }; 
    };
    Objects = {
        milk = {};
    };
    -- list of all triggers for an object
    Triggers = {
        Anger = {FuncName="AngerTriger", NotRunWhen={"eating","milking","watering","tools"}}
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {};   -- InitActiveTasks = {"eating"};
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
    -- RandomTasks=3     
    Cycle = {
        index=0;
        index_sleep=0;
        max_index = 0;
    };
};
--   ,   
life_cycle = {
    { "eating", 2 };
    { "watering", 3 };
    { "tools", 4 };
    { "milking", 8 };
};

function GameObject:Get()
    return self;
end

--        
function OnInit()
    OnInitHealth();
end

function isMayByTask(aTask)
    aObj = GameObject:Get(); 
    --if (aTask=="milking")then
    --    if((aObj.Params.health / aObj.Params.MaxHealth)<0.75)then
    --        return 0;
    --    end;
    --end;    
    return 1;   
end

function OnNextTask(aPrevTask, aNextTask)
    aObj = GameObject:Get();   
    --if (aNextTask=="milking") then        
    --    CPP_SetVisPrefix("_f");
    --end;
    --ScriptDump(""..aObj.Cycle.index);
    --ScriptDump(aNextTask);
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task EATING over external object and return true if task is completed
function EatingTaskExecute()
    aObject = GameObject:Get();
    if (aObject.Params.hungry == 5000) then
        CPP_SetAnimState("nasip_seno2");
    else 
        if (aObject.Params.hungry == 3000) then CPP_SetAnimState("nasip_seno1");
        else
            if (aObject.Params.hungry == 1000) then CPP_SetAnimState("eating_cow"); end
        end
    end
    local res = defEatingTaskExecute(aObject.Params,aObject.Tasks.eating);
    if (res == 0) then 
        CPP_SetAnimState("normal");
        SleepAfterTaskCycle();
        --SleepAfterTask(aObject.Tasks.eating);       
        aObject.Params.hungry = 5000;
        return 0;
    end
    return 1;
end
-- perform Task MILKING over external object and return true if task is completed
function MilkingTaskExecute()
    aObject = GameObject:Get();
    --CPP_CreateProduct(aObject.Params.product_name,GetProductCreate());
    local countProduct = GetProductCreate();
    CPP_SetVisPrefix("");   
    SleepAfterTaskCycle();
    CPP_ChildObjAnimState("milk","milk",3,1,countProduct);
    --SleepAfterTask(aObject.Tasks.milking);      
    return 0;
end

-- perform Task WATERING  over external object and return true if task is completed
function WateringTaskExecute()
    aObject = GameObject:Get();
        if (aObject.Params.thirst == 3000) then CPP_SetAnimState("drink_cow1");
        else
            if (aObject.Params.thirst == 1000) then CPP_SetAnimState("watering_cow"); end
        end
    local res = defWateringTaskExecute(aObject.Params,aObject.Tasks.watering);
    if (res == 0) then 
        CPP_SetAnimState("normal");
        aObject.Params.thirst = 5000;
        SleepAfterTaskCycle();
        --SleepAfterTask(aObject.Tasks.watering);     
        return 0;
    end
    return 1;
end
--  
function CleaningTaskExecute()
    aObject = GameObject:Get();
    CPP_SetAnimState("normal");
    SleepAfterTaskCycle();
    return 0;
end
